####################################################
### code chunk number : Simulations: 
### two inequalities
### delta_s, delta_2, PESL_s, PESL_2 
### three methods: oracle, moment, mle
### fix n and m
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
mu = 0        ## hyperparameter
alpha = 3     ## hyperparameter
beta = 1      ## hyperparameter
n = 1e4       ## sample size

## generate the sample
theta = 1 / rgamma(n = n + 1, shape = alpha, rate = beta)
x = rnorm(n = n + 1, mean = mu, sd = sqrt(theta)) 

## 
## oracle estimators
## 
## Compute_Estimators_PESLs_new
res_oracle = Compute_Estimators_PESLs_new(mu, alpha, beta, x_np1 = x[n + 1])
res_oracle

## 
## Moment estimators
## 
mu_1_alpha_1_beta_1 = Moment_estimators(x = x[1:n]); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1

## Compute_Estimators_PESLs_new
res_moment = Compute_Estimators_PESLs_new(mu = mu_1, alpha = alpha_1, beta = beta_1, x_np1 = x[n + 1])
res_moment
res_moment - res_oracle


## 
## MLEs
## 
## The MLEs are very sensitive to the initial guesses. 
## The moment estimators are usually good initial guesses.
## 
mu_2_alpha_2_beta_2 = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x[1:n])$root; mu_2_alpha_2_beta_2
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2

## Compute_Estimators_PESLs_new
res_MLE = Compute_Estimators_PESLs_new(mu = mu_2, alpha = alpha_2, beta = beta_2, x_np1 = x[n + 1])
res_MLE
res_MLE - res_oracle


####################################################
### code chunk number : Simulations: 
### two inequalities
### delta_s, delta_2, PESL_s, PESL_2 
### three methods: oracle, moment, mle
### fix n, m = 1, 2, ..., M = 100
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

ptm = proc.time()
## initialization
set.seed(1)
mu = 0               ## hyperparameter
alpha = 3            ## hyperparameter
beta = 1             ## hyperparameter
n = 1e4              ## sample size
M0 = 100; M0         ## number of required simulations
M1 = 120; M1         ## number of maximum tried simulations
## M2: number of actually tried simulations
## M:  number of effective simulations, finally M = M0

Matrix_M1_4 = matrix(0, nrow = M1, ncol = 4)
colnames(Matrix_M1_4) = c("delta_s", "delta_2", "PESL_s", "PESL_2")
res_oracle = res_moment = res_MLE = as.data.frame(Matrix_M1_4)
Index = numeric(M1)
names(Index) = 1:M1
Index_MLE_warning_error = mu_1 = alpha_1 = beta_1 = mu_2 = alpha_2 = beta_2 = Index
M = 0
for (m in 1:M1){
	cat("\n"); print(paste("In this cycle, m = ", m, sep = "")); cat("\n")
	M = M + 1
	set.seed(m)
	## generate the sample
	theta_m = 1 / rgamma(n = n + 1, shape = alpha, rate = beta)
	x_m = rnorm(n = n + 1, mean = mu, sd = sqrt(theta_m)) 

	## 
	## oracle estimators
	## 
	## Compute_Estimators_PESLs_new
	res_oracle[m, ] = Compute_Estimators_PESLs_new(mu, alpha, beta, x_np1 = x_m[n + 1])
	
	## 
	## Moment estimators
	## 
	mu_1_alpha_1_beta_1_m = Moment_estimators(x = x_m[1:n]); mu_1_alpha_1_beta_1_m
	mu_1[m] = mu_1_m = mu_1_alpha_1_beta_1_m[1]; mu_1_m
	alpha_1[m] = alpha_1_m = mu_1_alpha_1_beta_1_m[2]; alpha_1_m
	beta_1[m] = beta_1_m = mu_1_alpha_1_beta_1_m[3]; beta_1_m

	## Compute_Estimators_PESLs_new
	res_moment[m, ] = Compute_Estimators_PESLs_new(mu = mu_1_m, alpha = alpha_1_m, beta = beta_1_m, x_np1 = x_m[n + 1])

	## 
	## MLEs
	## 
	## The MLEs are very sensitive to the initial guesses. 
	## The moment estimators are usually good initial guesses.
	## 
	x = x_m[1:n] ## note here!
	mu_2_alpha_2_beta_2_m = tryCatch ( {
		Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1_m, x = x_m[1:n])$root
	} , warning = function ( w ) {
		mu_1_alpha_1_beta_1_m
	} , error = function ( e ) {
		mu_1_alpha_1_beta_1_m
	} , finally = {
		""
	}
	)
	
	if (all(mu_2_alpha_2_beta_2_m == mu_1_alpha_1_beta_1_m)){
		cat("\n mu_2_alpha_2_beta_2_m = mu_1_alpha_1_beta_1_m\n")
		Index_MLE_warning_error[m] = 1
	}
	
	mu_2[m] = mu_2_m = mu_2_alpha_2_beta_2_m[1]; mu_2_m
	alpha_2[m] = alpha_2_m = mu_2_alpha_2_beta_2_m[2]; alpha_2_m
	beta_2[m] = beta_2_m = mu_2_alpha_2_beta_2_m[3]; beta_2_m

	## Compute_Estimators_PESLs_new
	res_MLE[m, ] = Compute_Estimators_PESLs_new(mu = mu_2_m, alpha = alpha_2_m, beta = beta_2_m, x_np1 = x_m[n + 1])
	
	if (M == M0){
		M2 = m
		cat("\n"); print(paste("M == M0, M2 = ", m, sep = "")); cat("\n")
		break
	}
}
Index_MLE_warning_error
sum(Index_MLE_warning_error)
res_oracle
res_moment
res_MLE

## elapsed time: 2.11s
Time_compute = (proc.time() - ptm)[3]; Time_compute

res_oracle = res_oracle[1:M0, ]
res_moment = res_moment[1:M0, ]
res_MLE = res_MLE[1:M0, ]
mu_1 = mu_1[1:M0]
alpha_1 = alpha_1[1:M0]
beta_1 = beta_1[1:M0]
mu_2 = mu_2[1:M0]
alpha_2 = alpha_2[1:M0]
beta_2 = beta_2[1:M0]


##
## plot mu, alpha, beta, delta_s, delta_2, PESL_s, PESL_2
##
source("subfunctions.R")
Mu = rep(mu, M0)
Alpha = rep(alpha, M0)
Beta = rep(beta, M0)
plot_delta_PESL(x = 1:M0, y_oracle = Mu,    y_MLE = mu_2,    y_moment = mu_1, ylab = expression(mu), leg_pos = "top", fig_name = "N-IG_mu_vs_m", sub = "(a)")
plot_delta_PESL(x = 1:M0, y_oracle = Alpha, y_MLE = alpha_2, y_moment = alpha_1, ylab = expression(alpha), leg_pos = "top", fig_name = "N-IG_alpha_vs_m", sub = "(b)")
plot_delta_PESL(x = 1:M0, y_oracle = Beta,  y_MLE = beta_2,  y_moment = beta_1,  ylab = expression(beta),  leg_pos = "top", fig_name = "N-IG_beta_vs_m", sub = "(c)")
plot_delta_PESL(x = 1:M0, y_oracle = res_oracle[, 1], y_MLE = res_MLE[, 1], y_moment = res_moment[, 1], ylab = "delta_s", leg_pos = "topleft", fig_name = "N-IG_delta_s_vs_m", sub = "(d)")
plot_delta_PESL(x = 1:M0, y_oracle = res_oracle[, 2], y_MLE = res_MLE[, 2], y_moment = res_moment[, 2], ylab = "delta_2", leg_pos = "topleft", fig_name = "N-IG_delta_2_vs_m", sub = "(e)")
plot_delta_PESL(x = 1:M0, y_oracle = res_oracle[, 3], y_MLE = res_MLE[, 3], y_moment = res_moment[, 3], ylab = "PESL_s",  leg_pos = "bottom", fig_name = "N-IG_PESL_s_vs_m", sub = "(f)")
plot_delta_PESL(x = 1:M0, y_oracle = res_oracle[, 4], y_MLE = res_MLE[, 4], y_moment = res_moment[, 4], ylab = "PESL_2",  leg_pos = "bottom", fig_name = "N-IG_PESL_2_vs_m", sub = "(g)")


##
## moment vs MLE
##

## compute absolute error vectors
abs_error_moment_mu = abs(mu_1 - Mu); abs_error_moment_mu
abs_error_moment_alpha = abs(alpha_1 - Alpha); abs_error_moment_alpha
abs_error_moment_beta = abs(beta_1 - Beta); abs_error_moment_beta
abs_error_MLE_mu = abs(mu_2 - Mu); abs_error_MLE_mu
abs_error_MLE_alpha = abs(alpha_2 - Alpha); abs_error_MLE_alpha
abs_error_MLE_beta = abs(beta_2 - Beta); abs_error_MLE_beta

abs_error_moment = abs(res_moment - res_oracle); abs_error_moment
abs_error_MLE = abs(res_MLE - res_oracle); abs_error_MLE


## MSE_MAE_MEE_moment_MLE
source("subfunctions.R")
MSE_MAE_MEE_moment_MLE = matrix(0, nrow = 3, ncol = 6)
colnames(MSE_MAE_MEE_moment_MLE) = c("MSE_moment", "MSE_mle", "MAE_moment", "MAE_mle", "MEE_moment", "MEE_mle")
rownames(MSE_MAE_MEE_moment_MLE) = c("mu", "alpha", "beta")

MSE_MAE_MEE_moment_MLE[1, 1] = MSE_moment_mu = mean(abs_error_moment_mu^2); MSE_moment_mu
MSE_MAE_MEE_moment_MLE[2, 1] = MSE_moment_alpha = mean(abs_error_moment_alpha^2); MSE_moment_alpha
MSE_MAE_MEE_moment_MLE[3, 1] = MSE_moment_beta = mean(abs_error_moment_beta^2); MSE_moment_beta

MSE_MAE_MEE_moment_MLE[1, 2] = MSE_MLE_mu = mean(abs_error_MLE_mu^2); MSE_MLE_mu
MSE_MAE_MEE_moment_MLE[2, 2] = MSE_MLE_alpha = mean(abs_error_MLE_alpha^2); MSE_MLE_alpha
MSE_MAE_MEE_moment_MLE[3, 2] = MSE_MLE_beta = mean(abs_error_MLE_beta^2); MSE_MLE_beta

MSE_MAE_MEE_moment_MLE[1, 3] = MAE_moment_mu = mean(abs_error_moment_mu); MAE_moment_mu
MSE_MAE_MEE_moment_MLE[2, 3] = MAE_moment_alpha = mean(abs_error_moment_alpha); MAE_moment_alpha
MSE_MAE_MEE_moment_MLE[3, 3] = MAE_moment_beta = mean(abs_error_moment_beta); MAE_moment_beta

MSE_MAE_MEE_moment_MLE[1, 4] = MAE_MLE_mu = mean(abs_error_MLE_mu); MAE_MLE_mu
MSE_MAE_MEE_moment_MLE[2, 4] = MAE_MLE_alpha = mean(abs_error_MLE_alpha); MAE_MLE_alpha
MSE_MAE_MEE_moment_MLE[3, 4] = MAE_MLE_beta = mean(abs_error_MLE_beta); MAE_MLE_beta

MSE_MAE_MEE_moment_MLE[1, 5] = MEE_moment_mu = Compute_MEE(theta_hat = mu_1, theta = Mu); MEE_moment_mu
MSE_MAE_MEE_moment_MLE[2, 5] = MEE_moment_alpha = Compute_MEE(theta_hat = alpha_1, theta = Alpha); MEE_moment_alpha
MSE_MAE_MEE_moment_MLE[3, 5] = MEE_moment_beta = Compute_MEE(theta_hat = beta_1, theta = Beta); MEE_moment_beta

MSE_MAE_MEE_moment_MLE[1, 6] = MEE_MLE_mu = Compute_MEE(theta_hat = mu_2, theta = Mu); MEE_MLE_mu
MSE_MAE_MEE_moment_MLE[2, 6] = MEE_MLE_alpha = Compute_MEE(theta_hat = alpha_2, theta = Alpha); MEE_MLE_alpha
MSE_MAE_MEE_moment_MLE[3, 6] = MEE_MLE_beta = Compute_MEE(theta_hat = beta_2, theta = Beta); MEE_MLE_beta

MSE_MAE_MEE_moment_MLE

A = format(round(MSE_MAE_MEE_moment_MLE, 5), nsmall = 5); A
Generate_Matrix_Latex(A)

## 
## boxplots
## 

dev.new()
ylim = range(abs_error_moment_mu, abs_error_MLE_mu)
boxplot(abs_error_moment_mu, abs_error_MLE_mu, names = c("moment", "mle"), col = c("red", "blue"), ylab = expression(mu), ylim = ylim, sub = "(a)")
savePlot(filename = paste("figure/N-IG_boxplots_mu", sep=""), type = c("pdf"))

dev.new()
ylim = range(abs_error_moment_alpha, abs_error_MLE_alpha)
boxplot(abs_error_moment_alpha, abs_error_MLE_alpha, names = c("moment", "mle"), col = c("red", "blue"), ylab = expression(alpha), ylim = ylim, sub = "(b)")
savePlot(filename = paste("figure/N-IG_boxplots_alpha", sep=""), type = c("pdf"))

dev.new()
ylim = range(abs_error_moment_beta, abs_error_MLE_beta)
boxplot(abs_error_moment_beta, abs_error_MLE_beta, names = c("moment", "mle"), col = c("red", "blue"), ylab = expression(beta), ylim = ylim, sub = "(c)")
savePlot(filename = paste("figure/N-IG_boxplots_beta", sep=""), type = c("pdf"))

dev.new()
ylim = c(0, 0.1)
boxplot(abs_error_moment[, 1], abs_error_MLE[, 1], names = c("moment", "mle"), col = c("red", "blue"), ylab = "delta_s", ylim = ylim, sub = "(d)")
savePlot(filename = paste("figure/N-IG_boxplots_delta_s", sep=""), type = c("pdf"))

dev.new()
ylim = c(0, 0.1)
boxplot(abs_error_moment[, 2], abs_error_MLE[, 2], names = c("moment", "mle"), col = c("red", "blue"), ylab = "delta_2", ylim = ylim, sub = "(e)")
savePlot(filename = paste("figure/N-IG_boxplots_delta_2", sep=""), type = c("pdf"))

dev.new()
ylim = c(0, 0.1)
boxplot(abs_error_moment[, 3], abs_error_MLE[, 3], names = c("moment", "mle"), col = c("red", "blue"), ylab = "PESL_s", ylim = ylim, sub = "(f)")
savePlot(filename = paste("figure/N-IG_boxplots_PESL_s", sep=""), type = c("pdf"))

dev.new()
ylim = c(0, 0.1)
boxplot(abs_error_moment[, 4], abs_error_MLE[, 4], names = c("moment", "mle"), col = c("red", "blue"), ylab = "PESL_2", ylim = ylim, sub = "(g)")
savePlot(filename = paste("figure/N-IG_boxplots_PESL_2", sep=""), type = c("pdf"))


## 
## compute averages and proportions
## 

## compute averages
abs_error_moment_all = cbind(abs_error_moment_mu, abs_error_moment_alpha, abs_error_moment_beta, abs_error_moment)
colnames(abs_error_moment_all) = c("mu", "alpha", "beta", "delta_s", "delta_2", "PESL_s", "PESL_2")
abs_error_moment_all

abs_error_MLE_all = cbind(abs_error_MLE_mu, abs_error_MLE_alpha, abs_error_MLE_beta, abs_error_MLE)
colnames(abs_error_MLE_all) = c("mu", "alpha", "beta", "delta_s", "delta_2", "PESL_s", "PESL_2")
abs_error_MLE_all

averages_abs_error_moment_all = colMeans(abs_error_moment_all); averages_abs_error_moment_all
averages_abs_error_MLE_all = colMeans(abs_error_MLE_all); averages_abs_error_MLE_all

## compute proportions
source("subfunctions.R")
Averages_Proportions = matrix(0, nrow = 7, ncol = 4)
colnames(Averages_Proportions) = c("Averages_moment", "Averages_mle", "Proportions_moment", "Proportions_mle")
rownames(Averages_Proportions) = c("mu", "alpha", "beta", "delta_s", "delta_2", "PESL_s", "PESL_2")
Averages_Proportions[, 1] = averages_abs_error_moment_all
Averages_Proportions[, 2] = averages_abs_error_MLE_all
Averages_Proportions[1, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 1], v2 = abs_error_MLE_all[, 1])
Averages_Proportions[2, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 2], v2 = abs_error_MLE_all[, 2])
Averages_Proportions[3, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 3], v2 = abs_error_MLE_all[, 3])
Averages_Proportions[4, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 4], v2 = abs_error_MLE_all[, 4])
Averages_Proportions[5, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 5], v2 = abs_error_MLE_all[, 5])
Averages_Proportions[6, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 6], v2 = abs_error_MLE_all[, 6])
Averages_Proportions[7, 3:4] = Compute_Proportions_2vectors_pmin(v1 = abs_error_moment_all[, 7], v2 = abs_error_MLE_all[, 7])
round(Averages_Proportions, 4)

Averages = Averages_Proportions[, 1:2]; round(Averages, 4)
Proportions = Averages_Proportions[, 3:4]; round(Proportions, 2)
A = cbind(format(round(Averages, 4), nsmall = 4), format(round(Proportions, 2), nsmall = 2)); A
Generate_Matrix_Latex(A)


